(function() {
  //    FILE:EventCollection
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['jquery', 'Backbone', 'Backbone.LocalStorage', 'moment', 'models/event/EventModel', 'models/request/RequestModel'], function($, Backbone, LocalStorage, Moment, EventModel, RequestModel) {
    var EventCollection;
    return EventCollection = (function() {
      class EventCollection extends Backbone.Collection {
        initialize() {
          this.reqMdl = new RequestModel();
          this.DayNotes = [];
          this.DayPlans = [];
          return this.expiredTime = 5; //MINUTES TO REFRESH
        }

        comparator(event) {
          return event.get('timeIn');
        }

        get_dayNote(cDay) {
          var fDay;
          fDay = Moment(cDay).format('YYYY-MM-DD');
          return _.findWhere(this.DayNotes, {
            day: fDay
          });
        }

        set_day_events(usr, day, obj) {
          var dayTo, jsonReq, objID, response, that, type, xmlReq;
          that = this;
          jsonReq = this.reqMdl.get('JGetEvents');
          if (!day) {
            dayTo = Moment();
          } else {
            dayTo = Moment(day);
          }
          this.__clean_day_events(dayTo);
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'day', dayTo.format('YYYY-MM-DD'));
          if (obj) {
            this.reqMdl.__setNodeValue(jsonReq, 'objectType', obj.get('objectType'));
            type = obj.get('objectType');
            objID = obj.get('objectID');
            if ((type === 'sharedEventsView' || type === 'objectClass' || type === 'smartEventsView' || type === 'allEvents') && objID !== 'myEvents') {
              this.reqMdl.__setNodeValue(jsonReq, 'displayMode', 'eventSheet');
            }
            if (type === 'dayPlan') {
              this.reqMdl.__setNodeValue(jsonReq, 'displayMode', 'dayPlan');
            }
            this.reqMdl.__setNodeValue(jsonReq, 'objectID', objID);
          } else {
            this.reqMdl.__setNodeValue(jsonReq, 'objectType', usr.get('usersObjectType'));
            this.reqMdl.__setNodeValue(jsonReq, 'objectID', usr.get('usersObjectID'));
          }
          //objectCollection = 'user'
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var dayNote, eventDayPlan, eventSheetObjects, events, eventsObjectProperties, jsonObj, ref, ref1, ref2;
            jsonObj = data;
            events = jsonObj.Result.Event;
            eventsObjectProperties = jsonObj.Result.EventsObjectProperties;
            eventSheetObjects = jsonObj.Result.EventSheetObject;
            eventDayPlan = (ref = jsonObj.Result) != null ? (ref1 = ref.DayPlans) != null ? ref1.DayPlan : void 0 : void 0;
            dayNote = (ref2 = jsonObj.Result.DayNotes) != null ? ref2.DayNote : void 0;
            if (dayNote) {
              that.__add_day_note(dayNote);
            }
            if (eventDayPlan) {
              that.__add_day_plan(eventDayPlan);
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              if (eventSheetObjects) {
                that.add({
                  EventSheetObject: eventSheetObjects
                });
              }
              if (eventsObjectProperties) {
                that.add({
                  EventObjectsProperties: eventsObjectProperties
                });
              }
              if (_.isArray(events)) {
                _.each(events, function(ev) {
                  return that.add(ev);
                });
              } else if (events) {
                that.add(events);
              }
              return that.trigger('change');
            } else {
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                return window.location.href = 'index.html';
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
          return this;
        }

        get_week_events(usr, day) {
          var dayTo, i, j, jsonReq, response, that, week, xmlReq;
          that = this;
          this.reset();
          jsonReq = this.reqMdl.get('JGetEvents');
          if (!day) {
            dayTo = Moment();
          } else {
            dayTo = Moment(day);
          }
          week = [];
          for (i = j = 1; j <= 7; i = ++j) {
            week.push(dayTo.isoWeekday(i).format('YYYY-MM-DD'));
          }
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'day', week);
          this.reqMdl.__setNodeValue(jsonReq, 'objectType', usr.get('usersObjectType'));
          this.reqMdl.__setNodeValue(jsonReq, 'objectID', usr.get('usersObjectID'));
          //objectCollection = 'user'
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var dayNote, eventDayPlan, eventSheetObjects, events, eventsObjectProperties, jsonObj, ref, ref1, ref2;
            jsonObj = data;
            events = jsonObj.Result.Event;
            eventsObjectProperties = jsonObj.Result.EventsObjectProperties;
            eventSheetObjects = jsonObj.Result.EventSheetObject;
            eventDayPlan = (ref = jsonObj.Result) != null ? (ref1 = ref.DayPlans) != null ? ref1.DayPlan : void 0 : void 0;
            dayNote = (ref2 = jsonObj.Result.DayNotes) != null ? ref2.DayNote : void 0;
            if (dayNote) {
              that.__add_day_note(dayNote);
            }
            if (eventDayPlan) {
              that.__add_day_plan(eventDayPlan);
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              if (eventSheetObjects) {
                that.add({
                  EventSheetObject: eventSheetObjects
                });
              }
              if (eventsObjectProperties) {
                that.add({
                  EventObjectsProperties: eventsObjectProperties
                });
              }
              if (_.isArray(events)) {
                _.each(events, function(ev) {
                  return that.add(ev);
                });
              } else if (events) {
                that.add(events);
              }
              return that.trigger('change_week');
            } else {
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                return window.location.href = 'index.html';
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
          return this;
        }

        get_day_events(usr, day, obj) {
          var fDay;
          fDay = Moment(day).format('YYYY-MM-DD');
          if (!this.__is_update_needed(usr, day, obj)) {
            this.get_cached_events(usr, day, obj);
            return $.mobile.loading('hide');
          } else {
            return this.set_day_events(usr, fDay, obj);
          }
        }

        get_cached_events(usr, day) {
          var fDay;
          fDay = Moment(day).format('YYYY-MM-DD');
          return this.where({
            day: fDay
          });
        }

        get_eventSheetObjects() {
          var mod;
          mod = this.find(function(mdl) {
            if (mdl.get('EventSheetObject')) {
              return true;
            }
          });
          return mod != null ? mod.get('EventSheetObject') : void 0;
        }

        get_day_plan(day) {
          var fDay;
          fDay = Moment(day).format('YYYY-MM-DD');
          return _.findWhere(this.DayPlans, {
            day: fDay
          });
        }

        __clean_day_events(day) {
          var days, fDay;
          fDay = Moment(day).format('YYYY-MM-DD');
          days = this.where({
            day: fDay
          });
          return this.remove(days);
        }

        __is_update_needed(usr, day) {
          var event, lastUpdate, now;
          now = Moment();
          event = this.findWhere({
            day: Moment(day).format('YYYY-MM-DD')
          });
          if (!event) {
            return true;
          } else {
            lastUpdate = Moment.unix(event.get('TimeStamp'));
            if (now.diff(lastUpdate, 'minutes') > this.expiredTime) {
              return true;
            } else {
              return false;
            }
          }
        }

        __add_day_note(dayNote) {
          var exists;
          exists = _.findWhere(this.DayNotes, {
            day: dayNote.day
          });
          if (exists) {
            return _.each(this.DayNotes, function(dN) {
              if (dN.day === dayNote.day) {
                return dN.note = dayNote.note;
              }
            });
          } else {
            return this.DayNotes.push(dayNote);
          }
        }

        __add_day_plan(dayPlan) {
          var exists;
          exists = _.findWhere(this.DayPlans, {
            day: dayPlan.day
          });
          if (!exists) {
            return this.DayPlans.push(dayPlan);
          }
        }

      };

      EventCollection.prototype.model = EventModel;

      EventCollection.prototype.localStorage = new LocalStorage('Events');

      return EventCollection;

    }).call(this);
  });

}).call(this);
